-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );



TitleFont = {
  standardFont,
  70,
  BlackColor
};


MakeDialog
{
	-- Name the modal dialog
	name="creditswindow",
	Bitmap
	{
		image="images/backgrounds/bgpopup01",

		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=60,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "credits"
		};

		CreditsWindow
		{
			x = 0, y = 150,
			w = 800, h = 386,
			font = standardFont,
			fontsize = 16,
			fontcolor = BlackColor,
			headercolor = DarkBlueColor,
			columngap = 50,
			columnwidth = 325,
			time = 60000, 		-- Time to play credits in milliseconds
			intropause = 3000, 	-- Time to pause credits at start, in ms
			file = "credits/credits.txt",
		},

		Text
		{
			flags=kHAlignCenter + kVAlignTop,
			x=0,y=-22,
			w=kMax;h=39;
			label="#"..GetString("version",GetConfig(kGameVersion)) ;
		};
		SetStyle(FitnessButtonStyleTittleFlatBlue),
		SBButton
		{
			x=kCenter,
			y=kCenter+260,
			name="back",
			flags = kHAlignCenter + kVAlignCenter,
			
			icon="assets/images/ui/buttons/icon/iconback",	
			command =
				function()
					PopModal("creditswindow");
				end
		};
	},
}